import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:google_nav_bar/google_nav_bar.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_strings.dart';

import '../../screens/bottom_nav_section/home/home_screen.dart';
import '../../screens/bottom_nav_section/profile/profile_screen.dart';
import '../../screens/send_money_history/send_money_history_screen.dart';
import '../../screens/transection/transection_screen.dart';
class BottomNavBar2 extends StatefulWidget {
  const BottomNavBar2({super.key});

  @override
  State<BottomNavBar2> createState() => _BottomNavBar2State();
}

class _BottomNavBar2State extends State<BottomNavBar2> {
  List<Widget> screens = [const HomeScreen(), const TransactionScreen(), const SendMoneyHistory(), const ProfileScreen()];

  int selectedIndex = 0;
  final padding = const EdgeInsets.symmetric(horizontal: 16, vertical: 8);
  double gap = 10;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: screens[selectedIndex],
      bottomNavigationBar: SafeArea(
          child: Container(
          padding: const EdgeInsets.all(8),
          // margin: const EdgeInsets.symmetric(horizontal: 10, vertical: 5),
          decoration: BoxDecoration(
          color: Colors.white,
          // borderRadius: const BorderRadius.all(Radius.circular(100)),
          boxShadow: [
          BoxShadow(
            spreadRadius: -10,
            blurRadius: 60,
            color: Colors.black.withOpacity(.4),
            offset: const Offset(0, 25),
          )
        ],
        ),
        child: GNav(
          onTabChange: (value) {
            selectedIndex = value;
            setState(() {});
          },
        tabs: [
          GButton(
            gap: gap,
            iconActiveColor: MyColor.primaryColor,
            iconColor: MyColor.iconColor,
            textColor: MyColor.primaryColor,
            backgroundColor: MyColor.primaryColor.withOpacity(.2),
            iconSize: 24,
            padding: padding,
            icon: Icons.home_outlined,
            text: MyStrings.home.tr,
          ),
          GButton(
            gap: gap,
            iconActiveColor: MyColor.primaryColor,
            iconColor: MyColor.iconColor,
            textColor: MyColor.primaryColor,
            backgroundColor: MyColor.primaryColor.withOpacity(.2),
            iconSize: 24,
            padding: padding,
            icon: Icons.monetization_on_outlined,
            text: MyStrings.transaction.tr,
          ),
          GButton(
            gap: gap,
            iconActiveColor: MyColor.primaryColor,
            iconColor: MyColor.iconColor,
            textColor: MyColor.primaryColor,
            backgroundColor: MyColor.primaryColor.withOpacity(.2),
            iconSize: 24,
            padding: padding,
            icon: Icons.history,
            text: MyStrings.sendHistory,
          ),
          GButton(
            gap: gap,
            iconActiveColor: MyColor.primaryColor,
            iconColor: MyColor.iconColor,
            textColor: MyColor.primaryColor,
            backgroundColor: MyColor.primaryColor.withOpacity(.2),
            iconSize: 24,
            padding: padding,
            icon: Icons.person,
            text: MyStrings.profile.tr,
          ),
        ]),
      ),
    ));
  }
}
